/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// This needs updating since view is now a loop
// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {

        describe("Search Applet: Navbar of Layout", function () {
            var viewEl,
                model = new Backbone.Model({
                    configTypes: {
                        patients: { name: "Patient", title: "Patient Search" },
                        clinics: { name: "Clinic", title: "Clinic Search" },
                        wards: { name: "Ward", title: "Ward Search" },
                        recent: { name: "Last 20", title: "Last 20 Patients" }
                    },
                    title: 'Patient Search',
                    searchType: 'patient'
                });

            beforeEach(function () {
                spyOn(Portal.ListGenerator.Layout.prototype, 'initializeSearchViews').andCallFake(function() { return; });
                spyOn(Portal.ListGenerator.Layout.prototype, 'updateView').andCallFake(function() { return; });
                viewEl = new Portal.ListGenerator.Layout({
                    model: model
                }).render().$el;
            });
            afterEach(function() {
                viewEl.remove();
            });

            it("shows configured search types", function () {
                expect(viewEl.find('li:nth-of-type(1) a').attr('href')).toBe("#search-patients");
                expect(viewEl.find('li:nth-of-type(1) a').text()).toBe("Patient");
                expect(viewEl.find('li:nth-of-type(2) a').attr('href')).toBe("#search-clinics");
                expect(viewEl.find('li:nth-of-type(2) a').text()).toBe("Clinic");
                expect(viewEl.find('li:nth-of-type(3) a').attr('href')).toBe("#search-wards");
                expect(viewEl.find('li:nth-of-type(3) a').text()).toBe("Ward");
                expect(viewEl.find('li:nth-of-type(4) a').attr('href')).toBe("#search-recent");
                expect(viewEl.find('li:nth-of-type(4) a').text()).toBe("Last 20");
                //expect(viewEl.find('li:nth-of-type(5) a').attr('href')).toBe("#search-my-list");
                //expect(viewEl.find('li:nth-of-type(5) a').text()).toBe("My List");
            });
        });

        describe("Search Applet: Menu Configured", function () {
            var viewEl,
                model = new Backbone.Model({
                    configTypes: {
                        patients: { name: "Patient", title: "Patient Search" },
                        recent: { name: "Last 20", title: "Last 20 Patients" }
                    }
                });

            beforeEach(function () {
                spyOn(Portal.ListGenerator.Layout.prototype, 'initializeSearchViews').andCallFake(function() { return; });
                spyOn(Portal.ListGenerator.Layout.prototype, 'updateView').andCallFake(function() { return; });
                viewEl = new Portal.ListGenerator.Layout({
                    model: model
                }).render().$el;
            });
            afterEach(function() {
                viewEl.remove();
            });

            it("shows configured search types", function () {
                expect(viewEl.find('li:nth-of-type(1) a').attr('href')).toBe("#search-patients");
                expect(viewEl.find('li:nth-of-type(1) a').text()).toBe("Patient");
                expect(viewEl.find('li:nth-of-type(2) a').attr('href')).toBe("#search-recent");
                expect(viewEl.find('li:nth-of-type(2) a').text()).toBe("Last 20");
            });
        });
    });